import bpy
import os

def register_asset_library(addon_dir):
    """
    Ensures LPTK_ASSETPACK is registered as an asset library in Blender preferences.
    """
    assetpack_path = os.path.join(addon_dir, "LPTK_ASSETPACK")
    assetpack_path = bpy.path.abspath(assetpack_path)

    print("[LPTK] Asset Pack folder:", assetpack_path)

    # Access the asset libraries preferences
    prefs = bpy.context.preferences.filepaths

    # Check if already registered
    for lib in prefs.asset_libraries:
        if os.path.normpath(lib.path) == os.path.normpath(assetpack_path):
            print("[LPTK] Asset Library already registered:", lib.name)
            return

    # If not registered, add new asset library
    new_lib = prefs.asset_libraries.new(name="LPTK_ASSETPACK")
    new_lib.path = assetpack_path
    print("[LPTK] Asset Library registered at:", new_lib.path)
